/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp.evaluator.functions;

import java.util.Arrays;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.functions.BinaryFunction;

public class PPois
extends BinaryFunction {
    public PPois() {
        super("stats::ppois", Arrays.asList("x", "lambda"));
    }

    public FieldValue evaluate(FieldValue first, FieldValue second) {
        Integer x = first.asInteger();
        Double lambda = second.asDouble();
        Double result = PPois.ppois(x.intValue(), lambda);
        return FieldValueUtil.create((TypeInfo)TypeInfos.CONTINUOUS_DOUBLE, (Object)result);
    }

    public static double ppois(double x, double lambda) {
        x = Math.floor(x + 1.0E-7);
        GammaDistribution gammaDistribution = new GammaDistribution(x + 1.0, 1.0);
        return Math.log(gammaDistribution.cumulativeProbability(lambda));
    }
}

