/**
 * @file inst/include/mlpack.h
 * @author Yashwant Singh Parihar
 * @author Dirk Eddelbuettel
 *
 * Include all of the base components required to work mlpack bindings.
 *
 * mlpack is free software; you may redistribute it and/or modify it under the
 * terms of the 3-clause BSD license.  You should have received a copy of the
 * 3-clause BSD license along with mlpack.  If not, see
 * http://www.opensource.org/licenses/BSD-3-Clause for more information.
 */
#ifndef MLPACK_BINDINGS_R_MLPACK_H
#define MLPACK_BINDINGS_R_MLPACK_H

// With RcppArmadillo 15.0.1-1 or later, prefer current Armadillo
#if !defined(ARMA_USE_CURRENT)
  #define ARMA_USE_CURRENT
#endif

// This also includes the Rcpp headers along with RcppArmadillo
#include <RcppArmadillo.h>

// Rcpp has its own stream object which cooperates more nicely with R's i/o
// And like armadillo, mlpack can use this stream object as well.
#if !defined(MLPACK_COUT_STREAM)
  #define MLPACK_COUT_STREAM Rcpp::Rcout
#endif
#if !defined(MLPACK_CERR_STREAM)
  #define MLPACK_CERR_STREAM Rcpp::Rcerr
#endif

// Include the core library
#include <mlpack/core.hpp>

// Prevent inclusion of Rcpp.h and RcppArmadillo.h via the
// autogenerated RcppExports.cpp
#define Rcpp_hpp
#define RcppArmadillo__RcppArmadillo__h

#endif
