/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStream;

public class BakerTransformedStream
implements RandomStream {
    private RandomStream st;

    public BakerTransformedStream(RandomStream randomStream) {
        this.st = randomStream;
    }

    public void resetStartStream() {
        this.st.resetStartStream();
    }

    public void resetStartSubstream() {
        this.st.resetStartSubstream();
    }

    public void resetNextSubstream() {
        this.st.resetNextSubstream();
    }

    public String toString() {
        return "Baker transformation of " + ((Object)this.st).toString();
    }

    public double nextDouble() {
        double d = this.st.nextDouble();
        if (d > 0.5) {
            return 2.0 * (1.0 - d);
        }
        return d + d;
    }

    public int nextInt(int n, int n2) {
        return n + (int)(this.nextDouble() * ((double)(n2 - n) + 1.0));
    }

    public void nextArrayOfDouble(double[] dArray, int n, int n2) {
        this.st.nextArrayOfDouble(dArray, n, n2);
        for (int i = n; i < n + n2; ++i) {
            if (dArray[i] > 0.5) {
                dArray[i] = 2.0 * (1.0 - dArray[i]);
                continue;
            }
            int n3 = i;
            dArray[n3] = dArray[n3] + dArray[i];
        }
    }

    public void nextArrayOfInt(int n, int n2, int[] nArray, int n3, int n4) {
        for (int i = n3; i < n3 + n4; ++i) {
            nArray[i] = this.nextInt(n, n2);
        }
    }
}

