
library(ALS)
library(TIMP)

x2 <- 50:449  

x <-  5720:5800

Cmodel <- mass()
Cmodel@x <- x 
Cmodel@nt <- length(x)
Cmodel@extracomp <- FALSE

Cparam <- theta()

ntimes <- 25

abvar <- c(250,500,750,1000,1500,1750,2000)

ns <- array(dim=c(length(abvar),ntimes,2,2))

snr <- 1000
set.seed(10)

abr<-vector() 

for(j in 1:length(abvar)) { 
  for(i in 1:ntimes) {
  cat("********************************\n")
  cat("Noise realization",i,"var", j, "\n")
  cat("********************************\n")
  
  S <- as.matrix(read.table("S.R"))
  S[,1]<-S[,1]*abvar[j]
  
  Cparam@peakpar <- list(c(5749,7,1),c(5755,7,1)) 
  
  Cparam@amplitudes <- a1 <- c(1,2)
  C1 <- compModelMass(Cparam, Cmodel)
  
  Cparam@amplitudes <- a2 <- c(1.5,.5)

  C2 <- compModelMass(Cparam, Cmodel)
                                        
  Cst <- theta()

  Cst@peakpar <- list(c(5752,7,1),c(5753,7,1)) 
  
  Cst@amplitudes<-a1
  C1s <- compModelMass(Cst, Cmodel)
  Cst@amplitudes<-a2
  C2s <- compModelMass(Cst, Cmodel)

  c11<-sum(C1[,1]%*%t(S[,1]))
  c12<-sum(C1[,2]%*%t(S[,2]))
  c21<- sum(C2[,1]%*%t(S[,1]))
  c22<-sum(C2[,2]%*%t(S[,2]))
###abundance ratio 1st dataset 
   (r1<-c11/c12)
### abundance ratio 2nd dataset 
  (r2<-c21/c22)
  abr<-append(abr,r1)

  mc <- initModel(mod_type = "mass",
                  positivepar=c("amplitudes"), 
                  peakpar =Cst@peakpar, amplitudes=a1,
                  extracomp=FALSE, fixed = list(amplitudes=1:2))
     
  xx1 <- C1 %*% t(S)
  xx2 <- C2 %*% t(S)
  
  Cxx1<-snr^2 * (C1s/max(xx1))
  Cxx2<- snr^2 * (C2s/max(xx2))
  
  xx1 <- snr^2 * (xx1/max(xx1))
  xx2 <- snr^2 * (xx2/max(xx2))
  d1 <- rpois(length(xx1),xx1)
  d2 <- rpois(length(xx2),xx2)
  dim(d1)<-dim(xx1)
  dim(d2)<-dim(xx2)
  datList<-list()
  datList[[1]] <- dat(psi.df = d1,x = x, x2 = x2, 
                      nt = length(x), nl = length(x2), simdata = FALSE)
  datList[[2]] <- dat(psi.df = d2,x = x, x2 = x2, 
                      nt = length(x), nl = length(x2), simdata = FALSE)

  test0  <- try(als(CList=list(Cxx1,Cxx2),
                    PsiList=list(d1,d2), S=S, normS=1,
                    uniC = TRUE, optS1st=TRUE))
   
  test1 <- try(fitModel(data=datList,modspec=list(mc),
                        modeldiffs = list(change = list(
                  list(what = "fixed", dataset=2,
                       spec = list()),
                       list(what = "amplitudes", dataset = 2, spec = a2))),
                          opt=massopt(iter=50, nnls=TRUE, sumnls=FALSE,
                            algorithm="nls.lm", nummaxtraces=100, plot=FALSE)))
    
  if(class(test1)!="try-error") {
    S1 <- getSpecList(test1$currModel, test1$currTheta)[[1]]
    if( matchFactor(S[,1],S1[,1]) >  matchFactor(S[,1],S1[,2]) ) {
      ans[j,i,1,1] <- matchFactor(S[,1],S1[,1])
      ans[j,i,2,1] <- matchFactor(S[,2],S1[,2])
    }
    else {
      ans[j,i,1,1] <- matchFactor(S[,1],S1[,2])
      ans[j,i,2,1] <- matchFactor(S[,2],S1[,1])
    }
  }
  if(class(test0)!="try-error") {
    S2 <- test0$S
    if( matchFactor(S[,1],S2[,1]) >  matchFactor(S[,1],S2[,2]) ) { 
      ans[j,i,1,2] <- matchFactor(S[,1],S2[,1])
      ans[j,i,2,2] <- matchFactor(S[,2],S2[,2])
    }
    else{
      ans[j,i,1,2] <- matchFactor(S[,1],S2[,2])
      ans[j,i,2,2] <- matchFactor(S[,2],S2[,1])
    }
  }
  bigTMPAB<-ans
  save(bigTMPAB,file="bigTMPAB.R")
}
}
reab1<-ans
save(reab1,abr,file="reab1.R")


vm1 <- vm2 <- am1 <- am2 <- vector(length=length(abvar)) 
for(i in 1:length(abvar)) {
  vm1[i] <- mean(ans[i,,1,1])
  am1[i] <-  mean(ans[i,,1,2])
  vm2[i] <- mean(ans[i,,2,1])
  am2[i] <-  mean(ans[i,,2,2])
}

aa <- unique(abr)

pdf("varab1.pdf")

par(mfrow=c(2,1),cex=1.25, mar=c(4,5,3,2))

plot(aa,vm1,col=grey(c(.1)),ylim=c(.5,1),type="b",pch=18,
     ylab="matching factor",
     xlab="abundance ratio", main="Global analysis")

lines(aa,vm2,col=grey(c(.5)),type="b",pch=20)

plot(aa, am1,col=grey(c(.1)),ylim=c(.5,1),type="b",pch=18,
     ylab="matching factor",
     xlab="abundance ratio",, main="MCR-ALS")

lines(aa,am2,type="b",pch=20,col=grey(c(.5)))

dev.off()
